using System;
using System.IO;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Low_Memory_Candy
{
    // I am happy I never played Candy Crush Saga derp.
    public class Game : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        public const int screenWidth = 600;
        public const int screenHeight = 800;
        bool isFullscreen = false;
        int howMany = -1;
        public string path = Directory.GetCurrentDirectory() + "\\candy.txt";

        //Random ran = new Random(Guid.NewGuid().GetHashCode());
        Player p = new Player();
        //Color background;
        Bar bar;
        RainCandySystem sys;
        SpriteFont font;


        public Game()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Candys & Apples";
        }

        protected override void Initialize()
        {
            graphics.PreferredBackBufferWidth = screenWidth;
            graphics.PreferredBackBufferHeight = screenHeight;
            graphics.IsFullScreen = isFullscreen;
            graphics.ApplyChanges();

            if (File.Exists(path))
            {
                using (StreamReader read = new StreamReader(path))
                {
                    try
                    {
                        howMany = Convert.ToInt32(read.ReadLine());
                    }
                    catch
                    {
                        howMany = -56;
                    }
                }
            }

            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            font = Content.Load<SpriteFont>("font");
            sys = new RainCandySystem(new Texture2D[] { S.emptyTex(16, 8, Color.Azure, GraphicsDevice),
                S.emptyTex(16, 8, Color.BlanchedAlmond, GraphicsDevice),
                S.emptyTex(16, 8, Color.Pink, GraphicsDevice),
                S.emptyTex(20, 20, Color.Lime, GraphicsDevice) }, true, howMany);
            p.tex = S.emptyTex(24, 64, Color.Yellow, GraphicsDevice);
            p.pos = new Vector2(screenWidth / 2 - p.tex.Width / 2, screenHeight - p.tex.Height);

            bar = new Bar(S.emptyTex((screenWidth / 8) * 5, 20, Color.White, GraphicsDevice),
                new Vector2((screenWidth / 8) * 2, 22));

            try
            {
                p.jumps = new SoundEffect[] {
                    Content.Load<SoundEffect>("sound\\j1"),
                    Content.Load<SoundEffect>("sound\\j2") };
                p.powerup = Content.Load<SoundEffect>("sound\\pup");
                /*p.pickUps = new SoundEffect[] {
                    Content.Load<SoundEffect>("sound\\p1"),
                    Content.Load<SoundEffect>("sound\\p2"),
                    Content.Load<SoundEffect>("sound\\p3") };*/
                p.pickUps = new SoundEffect[] { 
                    Content.Load<SoundEffect>("sound\\nom"),
                    Content.Load<SoundEffect>("sound\\nomnom") };
            }
            catch
            {
                p.jumps = null;
                p.powerup = null;
                p.pickUps = null;
            }
        }

        protected override void Update(GameTime gameTime)
        {
            sys.update(p);
            p = sys.p;
            p.update(gameTime);

            bar.updateSize(p.memory / 10);

            if (p.memory <= 0) { p.gameOver = true; }
            /*if (p.trippy)
            {
                background = new Color(ran.Next(256), ran.Next(256), ran.Next(256));
                ran = new Random(ran.Next(int.MaxValue));
            }*/

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            if (!p.trippy) GraphicsDevice.Clear(Color.CornflowerBlue);
            else GraphicsDevice.Clear(Color.Magenta);

            spriteBatch.Begin();
            p.draw(spriteBatch, Color.White, font);
            sys.draw(spriteBatch);

            spriteBatch.DrawString(font, "Score: " + p.score, new Vector2(20, 20), Color.White);
            bar.draw(spriteBatch);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }

    public static class S
    {
        public static Texture2D emptyTex(int width, int height, Color c, GraphicsDevice dev)
        {
            Texture2D tex = new Texture2D(dev, width, height);
            Color[] clr = new Color[width * height];
            for (int i = 0; i < clr.Length; i++) clr[i] = c;
            tex.SetData(clr);
            return tex;
        }
    }
}
